<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content py-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom mb-0">
				<div class="card-header border-grey">
					<h3 class="card-title">
						<?php echo e(__('member.update_title')); ?>

					</h3>
				</div>
				<form method="post" action="<?php echo e(route('member.update', $member->id)); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="PATCH">
					<div class="card-body">
						<?php if(!empty($member->profile_picture)): ?>
						<div class="row mb-3">
							<div class="col-lg-12">
								<div class="user-image elevation-3" id="edit-image"
									style="background-image: url(' <?php echo e(asset('images/profile/'.$member->profile_picture)); ?> ');">
								</div>
							</div>
						</div>
						<?php endif; ?>
						<div class="row">
							<div class="col-lg-12">
								<div class="user-image elevation-3 d-none" id="image-preview"></div>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-6">
								<div class="form-group">
									<label for="reg_no"><?php echo e(__('member.reg_no')); ?></label>
									<input type="text" value="<?php echo e($member->reg_no); ?>" class="form-control" name="reg_no"
										id="reg_no" readonly>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="name" class="required"><?php echo e(__('member.name')); ?></label>
									<input type="text" value="<?php echo e($member->name); ?>"
										class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name" id="name">
									<?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
									<span class="d-block invalid-feedback"><?php echo e($message); ?></span>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="gender"><?php echo e(__('member.gender')); ?></label>
									<select class="form-control" name="gender" id="gender">
										<option value="male" <?php if($member->gender == 'male'): ?> selected <?php endif; ?>>
											Male
										</option>
										<option value="female" <?php if($member->gender == 'female'): ?> selected <?php endif; ?>>
											Female
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="age"><?php echo e(__('member.age')); ?></label>
									<input value="<?php echo e($member->age); ?>" type="text" class="form-control" name="age"
										id="age">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="phone" class="required"><?php echo e(__('member.phone')); ?></label>
									<input value="<?php echo e($member->phone); ?>" type="text"
										class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="phone"
										id="phone">
									<?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
									<span class="d-block invalid-feedback"><?php echo e($message); ?></span>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="address"><?php echo e(__('member.address')); ?></label>
									<input value="<?php echo e($member->address); ?>" type="text" class="form-control"
										name="address" id="address">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="height"><?php echo e(__('member.height')); ?></label>
									<input value="<?php echo e($member->height); ?>" type="text" class="form-control" name="height"
										id="height">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="weight"><?php echo e(__('member.weight')); ?></label>
									<input value="<?php echo e($member->weight); ?>" type="text" class="form-control" name="weight"
										id="weight">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="interested_area"><?php echo e(__('member.interested_area')); ?></label>
									<input value="<?php echo e($member->interested_area); ?>" name="interested_area" type="text"
										class="form-control" id="interested_area">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="profile_picture"><?php echo e(__('member.profile_picture')); ?></label>
									<div class="input-group">
										<div class="custom-file">
											<input name="profile_picture" type="file"
												class="custom-file-input <?php $__errorArgs = ['profile_picture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
												id="profile_picture">
											<label class="custom-file-label" for="profile_picture"><?php echo e(__('member.choose_file')); ?></label>
											<?php $__errorArgs = ['profile_picture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
											<span class="d-block invalid-feedback"><?php echo e($message); ?></span>
											<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
										</div>
									</div>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="status"><?php echo e(__('member.status')); ?></label>
									<select class="form-control" name="status" id="status">
										<option value="active" <?php if($member->status == 'active'): ?> selected <?php endif; ?>>
											Active
										</option>
										<option value="disabled" <?php if($member->status == 'disabled'): ?> selected <?php endif; ?>>
											Disabled
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-membership-type" class="required"><?php echo e(__('member.membership')); ?></label>
									<select
										class="form-control select-membership-type <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
										name="type" id="js-membership-type">
										<?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($type->id); ?>" data-duration="<?php echo e($type->duration); ?>"
											<?php if(isset($member->latest_membership->membership_type->id) &&
											$member->latest_membership->membership_type->id == $type->id): ?> selected
											<?php endif; ?>>
											<?php echo e($type->name); ?>

										</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
									<?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
									<span class="d-block invalid-feedback"><?php echo e($message); ?></span>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
								<input type="hidden" name="membership_id" value="<?php echo e($member->latest_membership->id); ?>">
							</div>

							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-from" class="required"><?php echo e(__('member.membership_valid_from')); ?></label>
									<div class="input-group date" id="date-valid-from" data-target-input="nearest">
										<input type="text"
											class="form-control datetimepicker-input <?php $__errorArgs = ['valid_from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
											value="<?php echo e(isset($member->latest_membership->valid_from) ? $member->latest_membership->valid_from : ''); ?>"
											name="valid_from" data-target="#date-valid-from" id="js-valid-from" />
										<div class="input-group-append" data-target="#date-valid-from"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									<?php $__errorArgs = ['valid_from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
									<span class="d-block invalid-feedback"><?php echo e($message); ?></span>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-to" class="required"><?php echo e(__('member.to')); ?></label>
									<div class="input-group date" id="date-valid-to" data-target-input="nearest">
										<input type="text"
											class="form-control datetimepicker-input <?php $__errorArgs = ['valid_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
											value="<?php echo e(isset($member->latest_membership->valid_to) ? $member->latest_membership->valid_to : ''); ?>"
											name="valid_to" data-target="#date-valid-to" id="js-valid-to" />
										<div class="input-group-append" data-target="#date-valid-to"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									<?php $__errorArgs = ['valid_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
									<span class="d-block invalid-feedback"><?php echo e($message); ?></span>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
							</div>

							<div class="col-lg-12">
								<?php if(!empty($member->memberships) && count($member->memberships) != 0): ?>
								<div clas="row">
									<div clas="col-12">
										<p class="lead"><?php echo e(__('member.membership_history')); ?></p>
										<div class="table-responsive">
											<table class="table custom-table-bordered table-hover">
												<thead>
													<tr>
														<th class="nowrap"><?php echo e(__('member.th_membership_type')); ?></th>
														<th><?php echo e(__('member.th_amount')); ?></th>
														<th class="nowrap"><?php echo e(__('member.th_valid_from')); ?></th>
														<th class="nowrap"><?php echo e(__('member.th_valid_to')); ?></th>
														<th class="nowrap"><?php echo e(__('member.th_created_at')); ?></th>
														<th class="nowrap"><?php echo e(__('member.th_action')); ?></th>
													</tr>
												</thead>
												<tbody>
													<?php $__currentLoopData = $member->memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td class="nowrap align-middle"><?php echo e($membership->membership_type->name); ?></td>
														<td class="nowrap align-middle"><?php echo e(format_amount($membership->membership_type->amount)); ?></td>
														<td class="nowrap align-middle"><?php echo e(format_date($membership->valid_from)); ?></td>
														<td class="nowrap align-middle"><?php echo e(format_date($membership->valid_to)); ?></td>
														<td class="nowrap align-middle"><?php echo e(format_date($membership->created_at)); ?></td>
														<td class="nowrap align-middle">
															<a href="<?php echo e(route('invoice.show', $membership->id)); ?>"
																type="button" class="btn btn-sm btn-warning mr-2">
																<i class="fa fa-print"></i>
															</a>
														</td>
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
								<?php endif; ?>
							</div>
							<div class="col-lg-6">
								<button type="submit" class="btn btn-primary mt-1"><?php echo e(__('member.update_member')); ?></button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-membership-type').select2({
			theme: 'bootstrap4'
		})

		// INITIALIZE THE DATE PICKER
		$('#date-valid-from').datetimepicker({
			format: 'YYYY-MM-DD'
		});

		$('#date-valid-to').datetimepicker({
			format: 'YYYY-MM-DD',
			readonly: true
		});

		// CALCULATE THE MEMBERSHIP VALID TO DATE
		$('#js-membership-type, #js-valid-from').on('change input', function () {
			var membershipId = parseInt($('#js-membership-type option:selected').val());
			var membershipDuration = parseInt($('#js-membership-type option:selected').data('duration'));
			var validFromDate = moment($('#js-valid-from').val(), 'YYYY-MM-DD');

			if (validFromDate.isValid() && !isNaN(membershipDuration)) {
				var validToDate = validFromDate.clone().add(membershipDuration, 'days');
				$('#js-valid-to').val(validToDate.format('YYYY-MM-DD'));
			}
		});

		// EVENT LISTENER TO PREVIEW PROFILE IMAGE
		$('.custom-file-input').on('change', function () {
			if (this.files && this.files[0]) {

				var file = this.files[0];

				var reader = new FileReader();

				reader.onload = function (e) {
					$('#image-preview').css('background-image', 'url(' + e.target.result + ')');
					$('#image-preview').removeClass('d-none');
					$('#edit-image').addClass('d-none');
					$('#image-preview').addClass('mb-3');
				};

				reader.readAsDataURL(file);

			} else {
				$('#image-preview').addClass('d-none');
				$('#image-preview').removeClass('mb-3');
			}
		});
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/member/edit.blade.php ENDPATH**/ ?>